<?php
if (isset($_POST['email'])) {
    $email_to = "info@seoengineers.in";
    $email_subject = "Enquiry from SEOEngineers.in";
 
    function died($error) {
        echo "We are very sorry, but there were error(s) found with the form you submitted. ";
        echo "These errors appear below.<br /><br />";
        echo $error . "<br /><br />";
        echo "Please go back and fix these errors.<br /><br />";
        die();
    }
 
    if (!isset($_POST['name']) ||
        !isset($_POST['email']) ||
        !isset($_POST['mobile']) ||
        !isset($_POST['message'])) {
        died('We are sorry, but there appears to be a problem with the form you submitted.');
    }
 
    $name = $_POST['name'];
    $email = $_POST['email'];
    $mobile = $_POST['mobile'];
    $message = $_POST['message'];
 
    $error_message = "";
 
    $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';
 
    if (!preg_match($email_exp, $email)) {
        $error_message .= 'The Email Address you entered does not appear to be valid.<br />';
    }
 
    $string_exp = "/^[A-Za-z .'-]+$/";
 
    if (!preg_match($string_exp, $name)) {
        $error_message .= 'The Name you entered does not appear to be valid.<br />';
    }
 
    if (strlen($message) < 2) {
        $error_message .= 'The message you entered does not appear to be valid.<br />';
    }
 
    if (strlen($error_message) > 0) {
        died($error_message);
    }
 
    $email_message = "Customer Inquiry Form.\n\n";
 
    function clean_string($string) {
        $bad = array("content-type", "bcc:", "to:", "cc:", "href");
        return str_replace($bad, "", $string);
    }
 
    $email_message .= "Name: " . clean_string($name) . "\n";
    $email_message .= "Email: " . clean_string($email) . "\n";
    $email_message .= "Mobile: " . clean_string($mobile) . "\n";
    $email_message .= "Message: " . clean_string($message) . "\n";
    $email_message .= "Page URL: " . $_SERVER['HTTP_REFERER'] . "\n";
 
    $headers = 'From: ' . $name . "\r\n" .
        'Reply-To: ' . $email . "\r\n" .
        'X-Mailer: PHP/' . phpversion();
 
    // Verify reCAPTCHA response
    $recaptcha_secret = '6LfPhiQmAAAAABSewZpNyaqKl8IMFNceSf3gNwcd';
    $recaptcha_response = $_POST['g-recaptcha-response'];
 
    $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
    $recaptcha_data = array(
        'secret' => $recaptcha_secret,
        'response' => $recaptcha_response
    );
 
    $recaptcha_options = array(
        'http' => array(
            'method' => 'POST',
            'content' => http_build_query($recaptcha_data)
        )
    );
 
    $recaptcha_context = stream_context_create($recaptcha_options);
    $recaptcha_result = file_get_contents($recaptcha_url, false, $recaptcha_context);
    $recaptcha_json = json_decode($recaptcha_result, true);
 
    if (!$recaptcha_json['success']) {
        died('reCAPTCHA verification failed. Please go back and complete the reCAPTCHA.');
    }
 
    @mail($email_to, $email_subject, $email_message, $headers);
 
    // Redirect after successful submission
    header('Location: https://www.seoengineers.in');
    exit();
}
?>

<!--start Contact us -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="favicon1.ico" />
    <title>Thanks You..Enquiry has been Sent Successfully !!</title>
    <meta http-equiv="refresh" content="0; URL=https://www.seoengineers.in">
</head>
<body>
    <h1 align="center">Thanks You..An inquiry has been Sent Successfully !! Wait for a moment</h1>
</body>
</html>
